/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.fuels;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.api.praescriptum.fuels.Fuel;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.common.util.ItemUtils;

public class FuelHandler {
    public final String name;
    protected final Logger logger;
    protected final Queue<Fuel> fuels = new ArrayDeque<Fuel>();
    protected final LoadingCache<Collection<InputIngredient<?>>, Fuel> cachedFuels = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(100L).build(this::getFuel);

    public FuelHandler(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The fuel handler name cannot be blank");
        }
        this.name = name;
        this.logger = LogManager.getLogger((String)("team_reborn|Praescriptum|" + name));
    }

    public Fuel addFuel() {
        return new Fuel(this);
    }

    public boolean addFuel(Fuel fuel, boolean replace) {
        Objects.requireNonNull(fuel.getInputIngredients(), "The source is null");
        if (fuel.getInputIngredients().size() <= 0) {
            throw new IllegalArgumentException("No sources");
        }
        if (fuel.getEnergyOutput() <= 0.0) {
            throw new IllegalArgumentException("The output is 0");
        }
        ArrayDeque queueOfSources = new ArrayDeque();
        for (InputIngredient<Object> ingredient : fuel.getInputIngredients()) {
            if (ingredient.isEmpty()) {
                this.logger.warn(String.format("The %s %s is invalid. Skipping...", ingredient.getClass().getSimpleName(), ingredient.toFormattedString()));
                continue;
            }
            queueOfSources.add(ingredient);
        }
        for (InputIngredient<Object> ingredient : queueOfSources) {
            if (!(ingredient instanceof OreDictionaryInputIngredient) || !OreDictionary.getOres((String)((String)((OreDictionaryInputIngredient)ingredient).ingredient)).isEmpty()) continue;
            this.logger.warn(String.format("Skipping %s => %s due to the non existence of items that are registered to a provided ore type", queueOfSources, fuel.getEnergyOutput()));
            return false;
        }
        Fuel temp = this.getFuel(queueOfSources);
        if (temp != null) {
            if (replace) {
                do {
                    if (this.removeFuel(queueOfSources)) continue;
                    this.logger.error(String.format("Something went wrong while removing the fuel with sources %s", queueOfSources));
                } while (this.getFuel(queueOfSources) != null);
            } else {
                this.logger.error(String.format("Skipping %s => %s due to duplicate source for %s (%s => %s)", queueOfSources, fuel.getEnergyOutput(), queueOfSources, queueOfSources, fuel.getEnergyOutput()));
                return false;
            }
        }
        Fuel newFuel = this.addFuel().addSources(queueOfSources).withEnergyOutput(fuel.getEnergyOutput()).withMetadata(fuel.getMetadata());
        this.fuels.add(newFuel);
        return true;
    }

    protected Fuel getFuel(Collection<InputIngredient<?>> ingredients) {
        for (Fuel fuel : this.fuels) {
            if (ingredients.size() != fuel.getInputIngredients().size()) continue;
            ArrayDeque adjusted = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient<?> entry : ingredients) {
                adjusted.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!adjusted.isEmpty()) continue;
            return fuel;
        }
        return null;
    }

    public Fuel findFuel(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        return this.cachedFuels.get(Collections.singletonList(ItemStackInputIngredient.copyOf(itemStack)));
    }

    public Fuel findFuel(Collection<ItemStack> itemStacks) {
        ArrayDeque<ItemStackInputIngredient> ingredients = new ArrayDeque<ItemStackInputIngredient>();
        for (ItemStack stack : itemStacks) {
            if (ItemUtils.isEmpty(stack)) continue;
            ingredients.add(ItemStackInputIngredient.copyOf(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return this.cachedFuels.get(ingredients);
    }

    public Fuel findFuel2(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            return null;
        }
        return this.cachedFuels.get(Collections.singletonList(FluidStackInputIngredient.copyOf(fluidStack)));
    }

    public Fuel findFuel2(Collection<FluidStack> fluidStacks) {
        ArrayDeque<FluidStackInputIngredient> ingredients = new ArrayDeque<FluidStackInputIngredient>();
        for (FluidStack stack : fluidStacks) {
            if (stack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.copyOf(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return this.cachedFuels.get(ingredients);
    }

    public Fuel findFuel3(Collection<ItemStack> itemStacks, Collection<FluidStack> fluidStacks) {
        ArrayDeque<InputIngredient> ingredients = new ArrayDeque<InputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.copyOf(itemStack));
        }
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.copyOf(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return this.cachedFuels.get(ingredients);
    }

    public Fuel findAndApply(ItemStack itemStack, boolean simulate) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        List<ItemStackInputIngredient> ingredients = Collections.singletonList(ItemStackInputIngredient.of(itemStack));
        Fuel fuel = this.cachedFuels.get(ingredients);
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return fuel;
        }
        return null;
    }

    public Fuel findAndApply(Collection<ItemStack> itemStacks, boolean simulate) {
        ArrayDeque<ItemStackInputIngredient> ingredients = new ArrayDeque<ItemStackInputIngredient>();
        for (ItemStack stack : itemStacks) {
            if (ItemUtils.isEmpty(stack)) continue;
            ingredients.add(ItemStackInputIngredient.of(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        Fuel fuel = this.cachedFuels.get(ingredients);
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return fuel;
        }
        return null;
    }

    public Fuel findAndApply2(FluidStack fluidStack, boolean simulate) {
        if (fluidStack.amount <= 0) {
            return null;
        }
        List<FluidStackInputIngredient> ingredients = Collections.singletonList(FluidStackInputIngredient.of(fluidStack));
        Fuel fuel = this.cachedFuels.get(ingredients);
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return fuel;
        }
        return null;
    }

    public Fuel findAndApply2(Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<FluidStackInputIngredient> ingredients = new ArrayDeque<FluidStackInputIngredient>();
        for (FluidStack stack : fluidStacks) {
            if (stack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        Fuel fuel = this.cachedFuels.get(ingredients);
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return fuel;
        }
        return null;
    }

    public Fuel findAndApply3(Collection<ItemStack> itemStacks, Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<InputIngredient> ingredients = new ArrayDeque<InputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.of(itemStack));
        }
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        Fuel fuel = this.cachedFuels.get(ingredients);
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque arrayDeque = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient entry : ingredients) {
                arrayDeque.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!arrayDeque.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient entry : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return fuel;
        }
        return null;
    }

    public boolean apply(Fuel fuel, ItemStack itemStack, boolean simulate) {
        if (ItemUtils.isEmpty(itemStack)) {
            return false;
        }
        List<ItemStackInputIngredient> ingredients = Collections.singletonList(ItemStackInputIngredient.of(itemStack));
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Fuel fuel, Collection<ItemStack> itemStacks, boolean simulate) {
        ArrayDeque<ItemStackInputIngredient> ingredients = new ArrayDeque<ItemStackInputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.of(itemStack));
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque arrayDeque = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    arrayDeque.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply2(Fuel fuel, FluidStack fluidStack, boolean simulate) {
        if (fluidStack.amount <= 0) {
            return false;
        }
        List<FluidStackInputIngredient> ingredients = Collections.singletonList(FluidStackInputIngredient.of(fluidStack));
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply2(Fuel fuel, Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<FluidStackInputIngredient> ingredients = new ArrayDeque<FluidStackInputIngredient>();
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque arrayDeque = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    arrayDeque.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply3(Fuel fuel, Collection<ItemStack> itemStacks, Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<InputIngredient> ingredients = new ArrayDeque<InputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.of(itemStack));
        }
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        if (fuel != null) {
            if (ingredients.size() != fuel.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(fuel.getInputIngredients());
            for (InputIngredient entry : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque arrayDeque = new ArrayDeque(fuel.getInputIngredients());
                for (InputIngredient entry : ingredients) {
                    arrayDeque.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeFuel(Fuel fuel) {
        if (fuel == null) {
            return false;
        }
        this.cachedFuels.invalidate(fuel);
        return this.fuels.remove(fuel);
    }

    public boolean removeFuel(Collection<InputIngredient<?>> ingredients) {
        Fuel fuel = this.getFuel(ingredients);
        if (fuel == null) {
            return false;
        }
        this.cachedFuels.invalidate(ingredients);
        return this.fuels.remove(fuel);
    }

    public Collection<Fuel> getFuels() {
        return this.fuels;
    }
}

